"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreatePayload = void 0;
const signature_v4_1 = require("@aws-sdk/signature-v4");
const credential_providers_1 = require("@aws-sdk/credential-providers");
const crypto_1 = require("crypto");
const sha256_js_1 = require("@aws-crypto/sha256-js");
const _1 = require(".");
/** @internal */
class CreatePayload {
    constructor(options) {
        const { region, ttl, userAgent, credentials } = options;
        this.region = region;
        this.ttl = ttl !== null && ttl !== void 0 ? ttl : "900";
        this.userAgent = userAgent !== null && userAgent !== void 0 ? userAgent : "MSK_IAM";
        this.credentials = credentials !== null && credentials !== void 0 ? credentials : (0, credential_providers_1.fromNodeProviderChain)();
        this.signature = new signature_v4_1.SignatureV4({
            credentials: this.credentials,
            region: this.region,
            service: _1.SERVICE,
            applyChecksum: false,
            uriEscapePath: true,
            sha256: sha256_js_1.Sha256,
        });
    }
    timestampYYYYmmDDFormat(date) {
        const d = new Date(date);
        return this.timestampYYYYmmDDTHHMMSSZFormat(d).substring(0, 8);
    }
    timestampYYYYmmDDTHHMMSSZFormat(date) {
        const d = new Date(date);
        return d.toISOString().replace(/[-.:]/g, "").substring(0, 15).concat("Z");
    }
    generateCanonicalHeaders(brokerHost) {
        return `host:${brokerHost}\n`;
    }
    generateXAmzCredential(accessKeyId, date) {
        return `${accessKeyId}/${date}/${this.region}/${_1.SERVICE}/aws4_request`;
    }
    generateStringToSign(date, canonicalRequest) {
        return `${_1.ALGORITHM}
${this.timestampYYYYmmDDTHHMMSSZFormat(date)}
${this.timestampYYYYmmDDFormat(date)}/${this.region}/${_1.SERVICE}/aws4_request
${(0, crypto_1.createHash)("sha256").update(canonicalRequest, "utf8").digest("hex")}`;
    }
    generateCanonicalQueryString(date, xAmzCredential, sessionToken) {
        let canonicalQueryString = "";
        canonicalQueryString += `${encodeURIComponent("Action")}=${encodeURIComponent(_1.ACTION)}&`;
        canonicalQueryString += `${encodeURIComponent("X-Amz-Algorithm")}=${encodeURIComponent(_1.ALGORITHM)}&`;
        canonicalQueryString += `${encodeURIComponent("X-Amz-Credential")}=${encodeURIComponent(xAmzCredential)}&`;
        canonicalQueryString += `${encodeURIComponent("X-Amz-Date")}=${encodeURIComponent(date)}&`;
        canonicalQueryString += `${encodeURIComponent("X-Amz-Expires")}=${encodeURIComponent(this.ttl)}&`;
        if (sessionToken !== undefined) {
            canonicalQueryString += `${encodeURIComponent("X-Amz-Security-Token")}=${encodeURIComponent(sessionToken)}&`;
        }
        canonicalQueryString += `${encodeURIComponent("X-Amz-SignedHeaders")}=${encodeURIComponent(_1.SIGNED_HEADERS)}`;
        return canonicalQueryString;
    }
    generateCanonicalRequest(canonicalQueryString, canonicalHeaders, signedHeaders, hashedPayload) {
        return ("GET\n" +
            "/\n" +
            canonicalQueryString +
            "\n" +
            canonicalHeaders +
            "\n" +
            signedHeaders +
            "\n" +
            hashedPayload);
    }
    create({ brokerHost }) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!brokerHost) {
                throw new Error("Missing values");
            }
            const { accessKeyId, sessionToken } = typeof this.credentials === "function"
                ? yield this.credentials()
                : this.credentials;
            const now = Date.now();
            const xAmzCredential = this.generateXAmzCredential(accessKeyId, this.timestampYYYYmmDDFormat(now));
            const canonicalHeaders = this.generateCanonicalHeaders(brokerHost);
            const canonicalQueryString = this.generateCanonicalQueryString(this.timestampYYYYmmDDTHHMMSSZFormat(now), xAmzCredential, sessionToken);
            const canonicalRequest = this.generateCanonicalRequest(canonicalQueryString, canonicalHeaders, _1.SIGNED_HEADERS, _1.HASHED_PAYLOAD); //
            const stringToSign = this.generateStringToSign(now, canonicalRequest);
            const signature = yield this.signature.sign(stringToSign, {
                signingDate: new Date(now).toISOString(),
            });
            return {
                version: "2020_10_22",
                "user-agent": this.userAgent,
                host: brokerHost,
                action: _1.ACTION,
                "x-amz-credential": xAmzCredential,
                "x-amz-algorithm": _1.ALGORITHM,
                "x-amz-date": this.timestampYYYYmmDDTHHMMSSZFormat(now),
                "x-amz-security-token": sessionToken,
                "x-amz-signedheaders": _1.SIGNED_HEADERS,
                "x-amz-expires": this.ttl,
                "x-amz-signature": signature,
            };
        });
    }
}
exports.CreatePayload = CreatePayload;
