import { Options } from ".";
/** @internal */
export type DateLike = number | Date | string;
/** @internal */
export type Payload = {
    version: string;
    "user-agent": string;
    host: string;
    action: string;
    "x-amz-credential": string;
    "x-amz-algorithm": string;
    "x-amz-date": string;
    "x-amz-security-token"?: string;
    "x-amz-signedheaders": string;
    "x-amz-expires": string;
    "x-amz-signature": string;
};
/** @internal */
export declare class CreatePayload {
    private readonly region;
    private readonly ttl;
    private readonly userAgent;
    private readonly credentials;
    private readonly signature;
    constructor(options: Options);
    timestampYYYYmmDDFormat(date: DateLike): string;
    timestampYYYYmmDDTHHMMSSZFormat(date: DateLike): string;
    generateCanonicalHeaders(brokerHost: string): string;
    generateXAmzCredential(accessKeyId: string, date: string): string;
    generateStringToSign(date: DateLike, canonicalRequest: string): string;
    generateCanonicalQueryString(date: string, xAmzCredential: string, sessionToken?: string): string;
    generateCanonicalRequest(canonicalQueryString: string, canonicalHeaders: string, signedHeaders: string, hashedPayload: string): string;
    create({ brokerHost }: {
        brokerHost: string;
    }): Promise<Payload>;
}
